/*
 * ListList.java
 *
 * Created on 15. August 2003, 21:03
 */

/**
 *
 * @author  Administrator
 */
import java.awt.event.*;
import javax.swing.*;
import java.util.*;

public class ListList_OOP extends javax.swing.JFrame {
    
    /** Creates new form ListList */
    public ListList_OOP() {
        super("Java: ListList_OOP");
        initComponents();
        // ListBox an Liste binden
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    private void initComponents() {//GEN-BEGIN:initComponents
        jDialog1 = new javax.swing.JDialog();
        bCreateTree = new javax.swing.JButton();
        bBenchCreate = new javax.swing.JButton();
        jScrollPane1 = new javax.swing.JScrollPane();
        listBox1 = new javax.swing.JList();

        jDialog1.setModal(true);

        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                exitForm(evt);
            }
        });

        bCreateTree.setText("bCreateTree (100 Entries)");
        bCreateTree.setMaximumSize(new java.awt.Dimension(200, 26));
        bCreateTree.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bCreateTreeActionPerformed(evt);
            }
        });

        getContentPane().add(bCreateTree, java.awt.BorderLayout.NORTH);

        bBenchCreate.setText("bBenchCreate (1 Mio Entries)");
        bBenchCreate.setMaximumSize(new java.awt.Dimension(200, 26));
        bBenchCreate.setMinimumSize(new java.awt.Dimension(180, 26));
        bBenchCreate.setPreferredSize(new java.awt.Dimension(180, 26));
        bBenchCreate.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                bBenchCreateActionPerformed(evt);
            }
        });

        getContentPane().add(bBenchCreate, java.awt.BorderLayout.CENTER);

        jScrollPane1.setPreferredSize(new java.awt.Dimension(300, 400));
        jScrollPane1.setViewportView(listBox1);

        getContentPane().add(jScrollPane1, java.awt.BorderLayout.SOUTH);

        pack();
    }//GEN-END:initComponents


    private void bBenchCreateActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bBenchCreateActionPerformed
    // 1 Million Objekte, 100 Millionen Suchvorgnge
        class ListBoxList extends javax.swing.AbstractListModel
        {
            ListBoxList (ArrayList newlist) { list = newlist;}
            ArrayList list;
            public int getSize() { return list.size(); }
            public Object getElementAt(int i) { return list.get(i); }
        };    
        showlist.clear();
        listBox1.setModel(new ListBoxList(showlist));
        java.awt.Graphics g = listBox1.getGraphics();
        listBox1.update(g);
        
    	long fullBench = 0;
	long constructionTime = 0;
	long destructionTime = 0;
	long findTime = 0;      
	long meanTime; 
        long start = 0;
        ClearList();        // synchron
        start = System.currentTimeMillis();
        for (int x = 1; x <= 10; x++)
        {
                meanTime = System.currentTimeMillis();
                BuildBaseList(100000);
                constructionTime += (System.currentTimeMillis() - meanTime); 
                meanTime = System.currentTimeMillis();
                ShowEntry("Search a: " + FindListEntry(RootDir, "a"));
		ShowEntry("Search ax: " + FindListEntry(RootDir, "ax"));
		ShowEntry("Search axv: " + FindListEntry(RootDir, "axv"));
		ShowEntry("Search axve: " + FindListEntry(RootDir, "axve"));
                for (int y = 1; y <= 20; y++)
                        FindListEntry(RootDir,"X"); // gibts nicht
                findTime += (System.currentTimeMillis() - meanTime); 
                listBox1.setModel(new ListBoxList(showlist));
                listBox1.update(g);
                
                meanTime = System.currentTimeMillis();
                ClearList();        
                destructionTime += (System.currentTimeMillis() - meanTime);                 
        }
        long diff = System.currentTimeMillis()-start;
        
        JTextArea txt = new JTextArea();
        txt.setText("Time:\t\t" + lToTString(diff) + 
            "\nfor Construction:\t"+ lToTString(constructionTime) +
            "\nfor Destruction:\t\t"+ lToTString(destructionTime) +
            "\nfor Find:\t\t"+ lToTString(findTime) );
        jDialog1 = new javax.swing.JDialog();
        jDialog1.setTitle("Java: ListList_OOP");
        jDialog1.setModal(true);
        jDialog1.setBounds(0, 0, 300, 150);
        jDialog1.getContentPane().add("Center", txt);
        jDialog1.show();
        
//        MessageBox.Show("Time: "+(timeGetTime()-STime).ToString());
    }//GEN-LAST:event_bBenchCreateActionPerformed

   
    String lToTString(long Millisecs)
    {
	String std, min, sec, ms; 
	std = "0" + Millisecs / 3600000; 
	min = "0" + Millisecs % 3600000 / 60000; 
	sec = "0"+ Millisecs % 60000 / 1000;
	ms = "00" + Millisecs % 1000;
        
        return std.substring(
            std.length()-2) + ":" + 
            min.substring(min.length()-2) + ":" + 
            sec.substring(sec.length()-2) + "." + 
            ms.substring(ms.length()-3); 
    }
    
    private String FindListEntry(SingleEntry List, String SubStr)
    {	SingleEntry E = List.FindEntry(SubStr);

            if (E != null) return E.FullName();
             else return "";
    }
    
    private void bCreateTreeActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_bCreateTreeActionPerformed
     // Demo-Liste mit 100 Elementen, Anzeige
     showlist.clear();
     
     listBox1.setModel(new javax.swing.AbstractListModel() 
     {
        public int getSize() { return showlist.size(); }
        public Object getElementAt(int i) { return showlist.get(i); }
     });    
     listBox1.repaint();
     ClearList();
     BuildBaseList(100); 
     PrintListList(RootDir, 1);
     listBox1.repaint();
     ClearList();

    }//GEN-LAST:event_bCreateTreeActionPerformed
    
    /** Exit the Application */
    private void exitForm(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_exitForm
        System.exit(0);
    }//GEN-LAST:event_exitForm
       void BuildListList(SingleEntry List, int Level)
       {
        // Listenaufbau (rekursiv)           
        int LocalCount = Rand.nextInt(25)+1;
        int NameLength;
        String NewName;

        // maximal 25 Eintrge pro Liste - nur das Stammverzeichnis
        // kann mehr haben
        for (int x = 1; x <= LocalCount; x++)
        {
           EntryCount--;
           // zuflliger Name mit 1-8 Zeichen
           NameLength = Rand.nextInt(8)+1;
           NewName = "";
           for (int y = 1; y <= NameLength; y++)
             NewName = NewName + (char)((int)'a' + Rand.nextInt(26));
                // Einzelner Eintrag oder neue Liste? Die Wahrscheinlichkeit
                // fr neue Listen (und weitere Rekursion) sinkt mit zunehmender
                // Verschachelungstiefe
            if (Rand.nextInt(10*Level) < 1)
              BuildListList(List.AddNode(NewName), Level+1);
            else List.AddEntry(NewName);
           
            if (EntryCount <= 0) break;
        }
    }    

    void ClearList()
    {
        RootDir = new ListEntry("C:");
        System.gc();
    }
    
    void BuildBaseList(int ECount)
    {
    // Legt die Elementenzahl fest und erzeugt das Stammverzeichnis        
	EntryCount = ECount;
	while (EntryCount > 0)
           BuildListList(RootDir,1);
    }
    
    void ShowEntry(String S) {
    // Anzeige in der Listbox, auch fr Suchergebnisse        
    showlist.add(S);
    }
    
    private void PrintListList(SingleEntry List, int Level)
    { // Ausgabe der Demo-Liste (100 Elemente)
        String Lead = "";
        SingleEntry CurEntry;

        for (int x = 1; x < Level; x++)
                Lead = Lead + "  ";

        // EntryName+' (LIST) fr Verzeichnisse
        ShowEntry(Lead+List.GetDisplayName());
        // Dateieintrge und Verzeichnisse, ungeordnet
        CurEntry = List.FirstEntry();
        while (CurEntry != null)
        {
                PrintListList(CurEntry, Level+1);
                CurEntry = List.NextEntry(CurEntry);
        }
    }

    
public class SingleEntry // einzelnes Element
{
        public String FEntryName;
        protected SingleEntry ParentList; // backtracking

        public SingleEntry(String EName) { FEntryName = EName; }
        public SingleEntry(String EName, SingleEntry Parent) 
        {
            this(EName);
            ParentList = Parent;
        }

        public String GetDisplayName() { return FEntryName; }

        public String FullName()
        {
           if (ParentList != null) return ParentList.FullName()+'\\'+ FEntryName;
           else return FEntryName;
        }

        public SingleEntry FindEntry(String PartialName)
        {
           if (FEntryName.equals(PartialName)) 
               return this; // 5.1
           else return null;
        }

        public SingleEntry AddEntry(String EName)
        { 
            return this;
        }

        public SingleEntry AddNode(String NName)
        { 
            return this;
        }

        public SingleEntry FirstEntry() { return null; }
        public SingleEntry NextEntry(SingleEntry CurEntry) { return null; }
    }

    public class ListEntry extends SingleEntry // Verzeichnis
    {
        private ArrayList EntryList = null;  // SingleEntry und ListEntry gemischt

        public ListEntry(String EName) 
        {
            super(EName);
            EntryList = new ArrayList();
        }

        public ListEntry(String EName, SingleEntry Parent) 
        {
            this(EName);
            ParentList = Parent;
        }

        public String GetDisplayName()
        { 
            return FEntryName + " (LIST)"; 
        }

        public SingleEntry FindEntry(String PartialName)
        {
            SingleEntry Result = super.FindEntry(PartialName);

            if (Result == null)
                for(int x = 0; x < EntryList.size(); x++)
                {
                    SingleEntry E = (SingleEntry)EntryList.get(x);
                    Result = E.FindEntry(PartialName);
                    if (Result != null) 
                        break;
                }
            return Result;
        }

        public SingleEntry AddEntry(String EName)
        {
            SingleEntry Result = new SingleEntry(EName, this);
            EntryList.add(Result);
            return Result;
        }

        public SingleEntry AddNode(String NName)
        {
            ListEntry Result = new ListEntry(NName, this);
            EntryList.add(Result);
            return Result;
        }
        public SingleEntry FirstEntry()
        {
            if (EntryList.size() == 0) return null;
            else return (SingleEntry)EntryList.get(0);
        }

        public SingleEntry NextEntry(SingleEntry CurEntry)
        {
            int x = EntryList.indexOf(CurEntry);

            if (x != -1 && x+1 < EntryList.size()) return (SingleEntry)EntryList.get(x+1);
            else return null;
        }
    }

    
    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {
        new ListList_OOP().show();
    }
    
    ArrayList showlist = new ArrayList();
    ListEntry RootDir = null; // "Stammverzeichnis"
    int EntryCount; // Runterzhler frs Anlegen der Struktur
    Random Rand = new Random();   
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton bBenchCreate;
    private javax.swing.JButton bCreateTree;
    private javax.swing.JDialog jDialog1;
    private javax.swing.JScrollPane jScrollPane1;
    private javax.swing.JList listBox1;
    // End of variables declaration//GEN-END:variables
    
}
